directories
end_directories;

settings
  operation_mode = real_time;
  startup_options
    call_procedures = true;
    activate_receivers = true;
    output_action = set_local;
  end_startup_options;
end_settings;


driver
end_driver;

data
end_data;

instrument

  panel panel_1;
    gui
      owner = background;
      position = 20, 565, 480, 60;
      gravity = right, bottom;
      window
        type = tool;
        title = 'Texturing Channel Control';
      end_window;
    end_gui;
  end_panel;

  label label_1;
    gui
      owner = panel_1;
      position = 5, 38;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      text = 'channel 1 uses scene for environment bitmap projection';
    end_text_list;
  end_label;

  label label_1;
    gui
      owner = panel_1;
      position = 5, 13;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      text = 'channel 0 is used for object''s surfaces texturing ';
    end_text_list;
  end_label;

  switch cswitch_1;
    gui
      owner = panel_1;
      position = 328, 34, 146, 21;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    startup_options
      call_procedures = false;
      activate_receivers = false;
    end_startup_options;
    mode = text_button;
    init_value = true;
    true_text = 'channel 1 enabled';
    false_text = 'channel 1 disabled';

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        teapot.EnableTextureLayerHierarchy( 1 );
      else
        teapot.DisableTextureLayerHierarchy( 1 );
      end;
    end_procedure;

  end_switch;

  switch switch_2;
    gui
      owner = panel_1;
      position = 328, 9, 146, 21;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    startup_options
      call_procedures = false;
      activate_receivers = false;
    end_startup_options;
    mode = text_button;
    init_value = true;
    true_text = 'channel 0 enabled';
    false_text = 'channel 0 disabled';

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        teapot.EnableTextureLayerHierarchy( 0 );
      else
        teapot.DisableTextureLayerHierarchy( 0 );
      end;
    end_procedure;

  end_switch;

  gl_scene gl_scene_1;
    gui
      owner = background;
      position = 20, 40, 480, 480;
      gravity = right, bottom;
      window
        type = normal;
        title = 'Bricky Teapot';
      end_window;
    end_gui;
    material
      item
        name = 'sphere_map';
        ambient = 0.150, 0.150, 0.150, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 0.250, 0.250, 0.250, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.508;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'nvlobby.bmp';
      end_item;
    end_material;
    camera
      position = -2E-006, 0, 926;
      rotation = 0, 0;
    end_camera;
  end_gl_scene;

  gl_model teapot;
    static
      angle : real;
      angle_step : real {init_value = 2.5};
    end_static;

    activity
      period = 0.05;
    end_activity;
    gui
      owner = gl_scene_1;
    end_gui;
    material
      item
        name = 'body';
        ambient = 0.100, 0.120, 0.150, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.688;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'bricks01.jpg';
      end_item;
    end_material;
    location
      translate = 22, -12.1, 61.6;
      rotate = 0, 0, 1, 0;
      scale = 3, 3, 3;
    end_location;
    normals_mode = computed_smooth;
    file = 'teapot.obj';

    procedure OnActivate();
    static
      x : real, 0;
      y : real, 1;
      z : real, 0;
      ax : real, 0;
      ay : real, 1;
      az : real, 0;
    begin
      ax = ax + 0.01;
      ay = ay + 0.01;
      az = az + 0.01;

      if ax > ( 2 * Pi ) then
        ax = 0;
      end;
      if ay > ( 2 * Pi ) then
        ay = 0;
      end;
      if az > ( 2 * Pi ) then
        az = 0;
      end;
      x = sin( ax );
      y = sin( ay );
      z = sin( az );

      angle = angle + angle_step;
      if angle > 360 then
        angle = angle - 360;
      end;
      self.Rotate( angle, x, y, z );
    end_procedure;

  end_gl_model;

end_instrument;

